#include "dm_nutypedefs.h"
#include "dm_i2c.h"
#include "dm_field_debug.h"

#ifdef DM_ENABLE_I2C_DEBUG

DM_I2C_LOG g_DmLogTableI2C[DM_I2C_LOG_SIZE];
UINT8 g_DmLogCountI2C = 0;
UINT8 g_DmLogEnabledI2C = 0;
UINT8 g_DmLogBusI2C = 0;

void DmClearLogI2C( void )
{
    g_DmLogCountI2C = 0;
}

void DmEnableLogI2C( UINT8 bEnable, UINT8 bBus )
{
    g_DmLogEnabledI2C = ( bEnable ? true : false );
    g_DmLogBusI2C = bBus;
}

void DmPrintLogI2C( void )
{
    UINT8 i;

    DmConsolePrintf("I2C Log\r\n");
    for ( i = 0; i < g_DmLogCountI2C; i++ )
    {
        DmConsolePrintf("(%d: 0x%02x, 0x%02x, %d, %d)\r\n", 
                        i, g_DmLogTableI2C[i].bChipAddr, 
                        g_DmLogTableI2C[i].bSubAddr, 
                        g_DmLogTableI2C[i].bCount, 
                        g_DmLogTableI2C[i].bWrite);
    }
}

#endif


